/*
 * Decompiled with CFR 0.152.
 */
package net.pevori.queencats.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.Team;
import net.pevori.queencats.QueenCats;
import net.pevori.queencats.entity.custom.HumanoidAnimalEntity;
import net.pevori.queencats.entity.variants.HumanoidCowVariant;
import net.pevori.queencats.item.ModItems;
import net.pevori.queencats.sound.ModSounds;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class HumanoidCowEntity
extends HumanoidAnimalEntity
implements IAnimatable {
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected Item itemForTaming = (Item)ModItems.GOLDEN_WHEAT.get();
    protected Item itemForGrowth = (Item)ModItems.KEMOMIMI_POTION.get();
    protected Ingredient itemForHealing = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_, (ItemLike)ModItems.GOLDEN_WHEAT.get()});
    protected static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(HumanoidCowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(HumanoidCowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    protected HumanoidCowEntity(EntityType<? extends HumanoidAnimalEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ModItems.KEMOMIMI_POTION.get();
    }

    protected SoundEvent m_7515_() {
        if (!QueenCats.enableCowSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_COW_AMBIENT.get();
    }

    public SoundEvent m_7866_(ItemStack stack) {
        if (!QueenCats.enableCowSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_COW_EAT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (!QueenCats.enableCowSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_COW_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (!QueenCats.enableCowSounds) {
            return (SoundEvent)ModSounds.HUMANOID_ENTITY_SILENT.get();
        }
        return (SoundEvent)ModSounds.HUMANOID_COW_DEATH.get();
    }

    protected SoundEvent getMilkingSound() {
        if (!QueenCats.enableCowSounds) {
            return null;
        }
        return (SoundEvent)ModSounds.HUMANOID_COW_MILK.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isSitting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidcow.sitting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidcow.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidcow.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationEvent event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.humanoidcow.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public boolean isMilkableVariant() {
        HumanoidCowVariant variant = this.getVariant();
        return variant != HumanoidCowVariant.MOOSHROOM || variant != HumanoidCowVariant.MOOBLOOM;
    }

    public boolean isStewableVariant() {
        HumanoidCowVariant variant = this.getVariant();
        return variant == HumanoidCowVariant.MOOSHROOM || variant == HumanoidCowVariant.MOOBLOOM;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSitting(tag.m_128471_("isSitting"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)tag.m_128451_("Variant"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isSitting", this.isSitting());
        tag.m_128405_("Variant", this.getTypeVariant());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public Team m_5647_() {
        return super.m_5647_();
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public HumanoidCowVariant getVariant() {
        return HumanoidCowVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(HumanoidCowVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

